/*****************************************************************************/
/*                                                                           */
/* Modul: EXTOBFIX.C                                                         */
/* Datum: 17.02.91                                                           */
/*                                                                           */
/*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <tos.h>
#include <portab.h>
#include <aes.h>
#include <vdi.h>

#include <nkcc.h>
#include <mglobal.h>
#include <mydial.h>
#include "exthelp.rsh"

/****** DEFINES **************************************************************/

/****** TYPES ****************************************************************/

/****** FUNCTIONS ************************************************************/

LOCAL  VOID    fix_objs      _((OBJECT *tree, BOOLEAN is_dialog));
LOCAL  VOID    (*get_name)   _((VOID *window, WORD obj, BYTE *txt));
LOCAL  VOID    free_userblk  _((OBJECT *tree));
GLOBAL LONG    pinit_obfix   _((BOOLEAN status));
LOCAL VOID     test_form     _((OBJECT *tree, WORD editobj, LONG get_n, VOID *window));

/****** VARIABLES ************************************************************/

extern WORD MyBlockLen;

LOCAL LONG routines[] =
{
	(LONG)fix_objs,
	(LONG)do_alert,
	(LONG)test_form,
	(LONG)&rs_object[0],
	'0610', '1965',				/* Magic */
	(LONG)pinit_obfix,
};

/*****************************************************************************/

LOCAL VOID fix_objs (tree, is_dialog)
OBJECT  *tree;
BOOLEAN is_dialog;

{
	dial_fix (tree, is_dialog);
}

/*****************************************************************************/

LOCAL VOID test_form (tree, editobj, get_n, window)
OBJECT *tree;
WORD   editobj;
LONG   get_n;
VOID   *window;

{	WORD     but, zw;
	BYTE     name[18], buf[200];
	DIALINFO di;

	*(LONG *)&get_name = get_n;
	
	fix_objs (tree, TRUE);
	tree->ob_x = tree->ob_y = 0;
  open_dial (tree, FALSE, NULL, &di);

	dial_draw (&di);
	
	zw = 2;
	do
	{	but = dial_do (&di, ROOT) & 0x7fff;
		tree [but].ob_state &= ~SELECTED;

		(*get_name) (window, but, name);
		sprintf (buf, "[0][Bouton de sortie :|%d = \'%s\' ][[Abandon|[Suite]", but, name);
		if ((zw = dial_alert (NULL, buf, 2, 1, ALI_LEFT)) == 2)
			objc_draw (tree, ROOT, MAX_DEPTH, di.x, di.y, di.w, di.h);
	}
	while (zw == 2);

  close_dial (FALSE, NULL, &di);

	free_userblk (tree);
}

/*****************************************************************************/

LOCAL VOID free_userblk (tree)
OBJECT *tree;

{	WORD obj = ROOT;

	do
	{
		if ((tree[obj].ob_type & 0xff00) == G_USERDEF)
			((OBBLK *)tree[obj].ob_spec)->ublk.ub_code = NULL;	/* librer USERBLK */
	}
	while (!(tree[obj++].ob_flags & LASTOB));
}

/*****************************************************************************/

main()
{	LOCAL dummy;

	if (dial_init (Malloc, Mfree, NULL, NULL, NULL))
	{
		nkc_init (NKI_NO200HZ, vdi_myhandle);				/* Initialise NKCC */
		nkc_set (0);
		dial_alert (NULL, "[0][Ce programme ne peut|etre dmarrer que par|Interface !][[Annule]", 1, 1, ALI_LEFT);
    nkc_exit ();																/* Termine NKCC */
	 	dial_exit ();
	}
	else
		dummy = routines[6];	/* sinon il faudra optimiser la structure de Pure C... */

	return (0);
}

/*****************************************************************************/

GLOBAL LONG pinit_obfix (status)
BOOLEAN status;

{	WORD i;

	if (status == TRUE)
	{	if (!dial_init (Malloc, Mfree, NULL, NULL, NULL))
			return (0L);
		else
		{
			nkc_init (NKI_NO200HZ, vdi_myhandle);								/* Initialise NKCC */
			nkc_set (0);

			i = 0;
			do
				rsrc_obfix (&rs_object[i], ROOT);
			while (!(rs_object[i++].ob_flags & LASTOB));

			return ((LONG)routines);
		}
	}
	else
	{	nkc_exit ();																/* Termine NKCC */
  	dial_exit ();
  }
	
	return (0L);
}
