/*****************************************************************************/
/*                                                                           */
/* Module: MGLOBAL.H                                                         */
/* Date : 15/05/91                                                           */
/*                                                                           */
/*****************************************************************************/

#ifndef __MGLOBAL__
#define __MGLOBAL__

/****** DEFINES **************************************************************/

#define DESK          0                   /* Window-Handle/classe du bureau comme objet */
#define RC            2                   /* Coordonnes graphiques */

#define FONT_SYSTEM   1                   /* GEM System Font */
#define FONT_SWISS    2                   /* Swiss Font */
#define FONT_DUTCH   14                   /* Dutch Font */

#ifndef max
#define max(a,b)    (((a) > (b)) ? (a) : (b)) /* Maximum-Function */
#define min(a,b)    (((a) < (b)) ? (a) : (b)) /* Minimum Function */
#endif

/****** TYPES *****************************************************************/

typedef struct
{
  WORD    mox;                            /* souris-X-Position */
  WORD    moy;                            /* souris-Y-Position */
  WORD    momask;                         /* Masque souris */
  WORD    mobutton;                       /* bouton souris lev/cliqu */
  WORD    kstate;                         /* Status de la touche Shift */
  UWORD   kreturn;                        /* Keycode of Event-Keyboard */
  WORD    breturn;                        /* nombre de clics */
  WORD    ascii_code;                     /* ASCII-Code from Keypress */
  WORD    scan_code;                      /* Scan-Code from keypress */
  BOOLEAN shift;                          /* avez-vous appuy sur shift ? */
  BOOLEAN ctrl;                           /* avez-vous appuy sur Cntrl ? */
  BOOLEAN alt;                            /* avez-vous appuy sur Altrn ? */
} MKINFO;                                 /* Mouse-Key-Info */

typedef struct
{
  WORD x;                                 /* X-coordonnes */
  WORD y;                                 /* Y-coordonnes */
  WORD w;                                 /* Largeur */
  WORD h;                                 /* Hauteur */
} RECT;

/****** VARIABLES ************************************************************/

extern WORD    vdi_myhandle;              /* Virtual Workstation Handle */

extern WORD    *my_mousnumber;            /* actual Mausnumber */
extern MFORM   **my_mousform;			  /* pointeur de la forme de la souris */
extern BOOLEAN *Grow;                     /* Grow/Shrink active ? */

/****** FUNCTIONS ************************************************************/

GLOBAL VOID    myxywh2rect    _((WORD x, WORD y, WORD w, WORD h, RECT *rect));
GLOBAL BOOLEAN myrc_equal     _((CONST RECT *p1, CONST RECT *p2));
GLOBAL VOID    myrc_copy      _((CONST RECT *ps, RECT *pd));
GLOBAL BOOLEAN myrc_intersect _((CONST RECT *p1, RECT *p2));
GLOBAL VOID    myrc_union     _((CONST REG RECT *p1, REG RECT *p2));
GLOBAL VOID    rect2array   _((CONST RECT *rect, WORD *array));
GLOBAL VOID    xywh2array   _((WORD x, WORD y, WORD w, WORD h, WORD *array));
GLOBAL VOID    obj_rand     _((OBJECT *tree, WORD obj, RECT *r));

GLOBAL VOID    objc_rect    _((OBJECT *tree, WORD obj, RECT *rect, BOOLEAN calc_border));
GLOBAL VOID    set_ptext    _((OBJECT *tree, WORD obj, BYTE *s));
GLOBAL VOID    get_ptext    _((OBJECT *tree, WORD obj, BYTE *s));

GLOBAL VOID    line_default _((WORD vdi_myhandle));

GLOBAL VOID    mybeep         _((VOID));

GLOBAL VOID    do_state     _((OBJECT *tree, WORD obj, UWORD state));
GLOBAL VOID    undo_state   _((OBJECT *tree, WORD obj, UWORD state));
GLOBAL VOID    do_flags     _((OBJECT *tree, WORD obj, UWORD flags));
GLOBAL VOID    undo_flags   _((OBJECT *tree, WORD obj, UWORD flags));

GLOBAL VOID    mygrowbox      _((CONST RECT *st, CONST RECT *fin));
GLOBAL VOID    myshrinkbox    _((CONST RECT *fin, CONST RECT *st));

GLOBAL VOID    set_mouse    _((WORD number, MFORM *addr));
GLOBAL VOID    last_mouse   _((VOID));
GLOBAL VOID    hide_mouse   _((VOID));
GLOBAL VOID    show_mouse   _((VOID));
GLOBAL VOID    busy_mouse   _((VOID));
GLOBAL VOID    arrow_mouse  _((VOID));

#endif /* __MGLOBAL__ */