/*****************************************************************************/
/*                                                                           */
/* Modul: MYDIAL.H                                                           */
/* Datum: 04/05/91                                                           */
/*                                                                           */
/*****************************************************************************/

#ifndef __MYDIAL__
#define __MYDIAL__

/****** DEFINES **************************************************************/

/* Erweiterte Objekttypen */
#define DIALMOVER  0x0011
#define DCRBUTTON  0x0012
#define UNDERLINE  0x0013
#define TITLELINE  0x0014
#define HELPBUT    0x0015
#define CIRCLEBUT  0x0016
#define UNDOBUT    0x001F

/* Flags fr popup_select */
#define	DO_POPUP		 0
#define	DO_CYCLE		-2
#define	DO_POPPREV	-1
#define	DO_POPNEXT	 1

/* Zentrierflags fr Alertboxtext */
#define ALCENTER   "\001"
#define ALRIGHT    "\002"

/****** TYPES ****************************************************************/

typedef struct
{
	LONG cookie;			/* doit tre 'VSCR' */
	LONG product;			/* identique  XBRA */
	WORD version;			/* Version du protocole VSCR, d'abord 0x100 */
	WORD x, y, w, h;	    /* zone visible de l'cran */
} INFOVSCR;

typedef struct
{
	OBJECT 	*Tree;
	MFDB 	Buffer;
	WORD 	x, y, w, h;
} DIALINFO;

typedef struct
{
	USERBLK	ublk;
	UWORD		old_type;
} OBBLK;

typedef WORD (*FORMKEYFUNC) (OBJECT *, WORD, WORD, WORD, WORD, WORD *, UWORD *);

typedef VOID (*FIXOBJFUNC) (OBJECT *tree, WORD obj);

/****** VARIABLES ************************************************************/

extern INFOVSCR *infovscr;

/****** FUNCTIONS ************************************************************/

/* rechercher les donnes de la police systme et l'installer comme police systme pour les programmes */
GLOBAL BOOLEAN get_sysfnt   _((WORD vdi_handle, WORD *font_id, WORD *gl_point, WORD *gl_wchar, WORD *gl_hchar));

/* rechercher Cookie ; si TRUE, alors Cookie trouve */
GLOBAL BOOLEAN getcookie    _((LONG cookie, LONG *p_value));

/* est-ce qu'une cookie VSCR existe et que l'cran visible est plus petit que l'cran total */
GLOBAL BOOLEAN ask_vscr     _((VOID));

/*****************************************************************************/

/* rechercher l'objet parent; si ROOT alors NIL (-1) est renvoy */
GLOBAL WORD    parent       _((OBJECT *tree, WORD obj));

/* rechercher ob_spec (mme pour les objets USERDEF) */
GLOBAL LONG    get_obspec   _((OBJECT *tree, WORD obj));

/* modifier ob_spec (mme pour les objets USERDEF) */
GLOBAL VOID    set_obspec   _((OBJECT *tree, WORD obj, LONG obspec));

/* remplacer evnt_multi kstate et kreturn grace  NKCC en KeyCode normaliss */
GLOBAL UWORD   normkey      _((WORD ks, WORD kr));



/*****************************************************************************/

/* insre une fonction spciale qui sera appele par la suite lorsque le type */
/* d'objet tendu d'un Mydial est reconnu.									  */
GLOBAL VOID set_fixobj       _((FIXOBJFUNC fun));

/* indique un pointeur pour une fonction dfinissable par l'utilisateur */
GLOBAL FIXOBJFUNC get_fixobj _((VOID));

/* montrer USERBLK pour un objet, ensuite changer l'objet dans Userdef */
GLOBAL USERBLK *add_ublock   _((WORD cdecl (*code)(PARMBLK *parmblock), LONG obspec, WORD type));



/*****************************************************************************/

/* identique  form_do: appel du dialogue */
GLOBAL WORD    dial_do      _((DIALINFO *di, WORD edit_obj));

/* dplacement de dialogue; x,y,w,h dfinissent les marges maxi (en principe la taille du bureau sans la ligne de menu  */
/* dial_move est aussi utilis par dial_do */
GLOBAL VOID    dial_move    _((DIALINFO *di, WORD x, WORD y, WORD w, WORD h));

/* remplissage de la structure DIALINFO avec des valeurs, mmoriser le fond */
GLOBAL BOOLEAN dial_start   _((OBJECT *tree, DIALINFO *di));

/* restaurer le fond, librer la mmoire */
GLOBAL VOID    dial_end     _((DIALINFO *di));

/* centrer le dialogue ; identique  form_center */
GLOBAL VOID    dial_center  _((OBJECT *tree));

/* montrer le dialogue; identique  objc_draw */
GLOBAL VOID    dial_draw    _((DIALINFO *di));



/*****************************************************************************/

/* chercher la ligne suivante d'un champ  entres multiples */
GLOBAL WORD    find_next    _((OBJECT *tree, WORD obj));

/* chercher la ligne prcdente d'un champ  entres multiples */
GLOBAL WORD    find_prev    _((OBJECT *tree, WORD obj));

GLOBAL WORD    get_idx      _((OBJECT *tree, WORD obj, WORD cpos));

/* remplace form_keybd,  appeler avec les routines claviers dfinies par l'utilisateur sous set_Keybd avec les paramtres identiques */
/* voir form_keybd pour les paramtres */
GLOBAL WORD    form_Keybd   _((OBJECT *tree, WORD edit_obj, WORD next_obj, WORD kr, WORD ks, WORD *onext_obj, UWORD *okr));

/* chercher un raccourci dans un objet Arbre; renvoi l'objet ou NIL               */
/* startobj: arbre de dpart pour la recherche des raccourcis clavier             */
/*           Normalement ROOT ( Popups)                                           */
/* ks, kr  : Rckgabewerte von evnt_multi, die den Shortcut beschreiben */
GLOBAL WORD    shortcut     _((OBJECT *tree, WORD startobj, WORD ks, WORD kr));

/* insertion de la routine clavier indpendante dans form_Keybd */
/* quand la routine ne peut valuer la touche, il faut lui retourner NIL, */
/* sinon la valeur de retour de form_button ou form_keybd. */
/* a la fin du dialogue, la routine sera enleve */
GLOBAL VOID    set_Keybd    _((FORMKEYFUNC fun));

/* rechercher l'adresse de la routine utilisateur insre */
GLOBAL FORMKEYFUNC get_Keybd _((VOID));

/* objc_edit propre  Mydial                                    */
/* lorsque le dialogue est dans une fenetre, winhndl            */
/* doit connaitre l'identification de cette fenetre, sinon NIL. */
/* Le curseur sera plac dans l'angle droit de la liste         */
/* afin d'viter des erreurs de redraw.                         */
GLOBAL WORD		obj_edit		_((OBJECT *ob_edtree, WORD ob_edobject, WORD kstate, WORD ob_edchar, WORD *ob_edidx, WORD ob_edkind, WORD mode, WORD *next_obj, WORD winhndl));

/*****************************************************************************/

/* remplace form_alert, appelle dial_alert avec dial_alert (NULL, string, defbut, 0, ALI_LEFT). */
GLOBAL WORD    do_alert     _((WORD defbut, CONST BYTE *txt));

/* appel tendu de form_alert: */
/* alicon : appliquer l'icone propre; si NULL, l'affichage de l'icne sera utilise en chane */
/* string : chane d'alerte, comme dans form_alert */
/*			quand le texte d'un bouton commence avec un point, il sera considr comme bouton par dfaut */
/*			s'il commence par un double point, il sera considr comme bouton Undo par dfaut */
/*			Dans ces deux cas, les valeurs de defbut et undobut seront ignores. */
/* defbut : bouton de sortie par dfaut */
/* undobut: bouton Undo par dfaut, sera utilis par la touche UNDO */
/* align  : positionnement du texte d'alerte: ALI_LEFT, ALI_CENTER, ALI_RIGHT, dfinis dans VDI.H */
/*          Les lignes isoles peuvent tre positionnes grace  ALCENTER ou ALRIGHT */
GLOBAL WORD    dial_alert   _((BITBLK *alicon, CONST BYTE *string, WORD defbut, WORD undobut, WORD align));

/* renvoi  un numro d'icne le pointeur dans la structure BITBLK */
GLOBAL BITBLK  *get_icon    _((WORD icon));

/* dcomposition de la chane d'alerte en 8 chanes individuelles, 5 lignes de texte et 3 boutons. */
/* renvoie le numro d'icne */
GLOBAL WORD    al_token     _((CONST BYTE *f_alert, BYTE str[8][50], WORD *txtnum, WORD *butnum));



/******************************************************************************/

/* popup_menu: Montrer un menu Popup														*/
/* tree      : Adresse de l'arbre objet dans lequel se trouve le menu Popup					*/
/* obj       : index du Popup																*/
/* x, y      : position du coin Haut-Gauche du Popup (sinon du centre de l'objet, 			*/
/*             lorsque center_obj != NIL)													*/
/* center_obj: contient l'index de l'entre Popup  centrer									*/
/* relative  : TRUE: sera affich  la position souris, x et y								*/
/*             doivent tre  0.															*/
/* bmsk      : indique le bouton souris qui a t utilis pour quitter le Popup				*/
/*             (1 = gauche, 2 = droite, comme pour l'AES)									*/
/* ok        : TRUE quand le fond peut tre sauv, FALSE sinon								*/
/* rsultat  : entre choisie ou NIL														*/

GLOBAL WORD    popup_menu   _((OBJECT *tree, WORD obj, WORD x, WORD y, WORD center_obj, BOOLEAN relative, WORD bmsk, BOOLEAN *ok));

/* popup_select: changer dans le dialogue le bouton Popup avec le bouton de Cyclage			*/
/* dialtree  : arbre dialogue																*/
/* btn       : index de l'objet appel par le Popup (types accepts: BoxText, Button, String, Userdef-Boxtext ou Userdef-Button) */
/* poptree   : Adresse de l'arbre objet dans lequel se trouve le menu Popup.				*/
/* obj       : Index du Popup																*/
/*			   Les entres isoles doivent tre comme des chanes ou Chanes accessibles au clavier (Userdef 19) */
/* docheck   : vrifier l'entre Popup (avec Button-text)									*/
/* docycle   : DO_POPUP: montrer le Popup; DO_CYCLE, DO_POPNEXT: montrer l'entre suivante	*/
/*             DO_POPPREV: montrer l'entre prcdente										*/
/* ok        : TRUE, quand le fond peut tre sauv, FALSE sinon								*/
/* rsultat  : entre choisie ou NIL														*/

GLOBAL WORD	   popup_select _((OBJECT *dialtree, WORD btn, OBJECT *poptree, WORD obj, BOOLEAN docheck, WORD docycle, BOOLEAN *ok));



/*****************************************************************************/

/* ouvrir le dialogue, appelle Growbox , et dial_start 						 				*/
/* size = NULL est le point de sortie de la Growbox du milieu d'cran						*/
/* la valeur de retour dfinit si le fond peut tre sauv ou non							*/
GLOBAL BOOLEAN open_dial    _((OBJECT *tree, BOOLEAN grow, RECT *size, DIALINFO *dialinfo));

/* Fermer le dialogue, appelle Shrinkbox , et dial_end 										*/
/* size = NULL est le point de destination de la Shrinkbox du milieu de l'cran 			*/
GLOBAL BOOLEAN close_dial   _((BOOLEAN shrink, RECT *size, DIALINFO *dialinfo));

/* gestion complte du dialogue, appelle open_dial, do_dial et close dial					*/
/* le renvoi indique si le fond peut tre sauv.	 										*/
GLOBAL WORD    HndlDial     _((OBJECT *tree, WORD def, BOOLEAN grow_shrink, RECT *size, BOOLEAN *ok));



/*****************************************************************************/

/* inscrit l'objet USERDEF, is_dialog dfinit si c'est une bote de dialogue ou un menu droulant	*/
GLOBAL VOID    dial_fix     _((OBJECT  *tree, BOOLEAN is_dialog));

/* initialisation du Mydial.  effectuer 1 fois au dmarrage.										*/
/* nkc_init et nkc_set ne seront PAS appele dial_init, il faut le faire  partir du programme principal   */
GLOBAL BOOLEAN dial_init    _((VOID *alc, VOID *fr, WORD *mnum, MFORM **mform, BOOLEAN *gs));

/* Suppression du Mydial.  effectuer une fois  la fin du programme. */
/* nkc_exit n'est PAS appele par dial_exit, il faut le faire  partir du programme principal 		*/
GLOBAL BOOLEAN dial_exit    _((VOID));



/*****************************************************************************/

/* Efface le clipboard GEM */
GLOBAL WORD    scrap_clear _((VOID));

/* modifie le titre de la table ASCII. surtout pour les traductions.      	*/
/* parce que le ressource Mydial n'est pas ici.								*/
/* l'en-tte doit tre une chane. Les Mydials ne modifient que le pointeur */
/* Il faut donc imprativement que la chane soit bien dfinie au paravent. */
GLOBAL VOID    ascii_head _((BYTE *header));



/*****************************************************************************/

/* rechercher le raccourci clavier dans un arbre menu	                    */
/* menu  : arbre menu					                                    */
/* mk    : structure dcrivant la touche presse							*/
/* title : le titre du menu de "item"					                    */
/* item  : entre correspondante au raccourci clavier						*/
/* rsultat: TRUE = raccourci clavier trouv, sinon FALSE     */

GLOBAL BOOLEAN my_menu_key  _((OBJECT *menu, MKINFO *mk, WORD *title, WORD *item));

#endif /* __MYDIAL__ */
