/*****************************************************************************/
/*                                                                           */
/* Modul: EXTOBFIX.C                                                         */
/* Datum: 17.02.91                                                           */
/*                                                                           */
/*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <portab.h>
#include <aes.h>
#include <vdi.h>

#include "xrsrcfix.h"
#include "crshtest.rh"
#include "crshtest.rsh"

/****** DEFINES **************************************************************/

#define DESK          0        /* Window-Handle */
#define RC            2        /* Coordonnes graphiques */

/****** TYPES ****************************************************************/

/****** VARIABLES ************************************************************/

#if DR_C | LASER_C | MW_C
EXTERN WORD   gl_apid;                   /* Identification pour Application */
#else
LOCAL WORD    gl_apid;                   /* Identification pour Application */
#endif

LOCAL WORD    gl_wattr;                  /* Largeur de l'attribut de fentre */
LOCAL WORD    gl_hattr;                  /* Hauteur de l'attribut de fentre */

LOCAL WORD    phys_handle;               /* Physical Workstation Handle */
LOCAL BOOLEAN vwork_open;                /* Virtual Workstation open ? */

LOCAL OBJECT  *dialbox;

WORD          vdi_handle;                /* Virtual Workstation Handle */
WORD          gl_wbox;                   /* Largeur d'une bote Signe (caractre) */
WORD          gl_hbox;                   /* Hauteur d'une bote signe */
GRECT         desk;                      /* Taille du bureau */

/****** FUNCTIONS ************************************************************/

LOCAL VOID       fix_objs      _((OBJECT  *tree));
LOCAL VOID       trans_gimage  _((VOID *obspec, WORD typ));
LOCAL VOID       open_vwork    _((VOID));
LOCAL VOID       close_vwork   _((VOID));
LOCAL BOOLEAN    init_global   _((INT argc, BYTE *argv [], BYTE *acc_menu, WORD class));
LOCAL BOOLEAN    term_global   _((VOID));

LOCAL VOID       vdi_fix       _((MFDB *pfd, VOID *theaddr, WORD wb, WORD h));
LOCAL VOID       vdi_trans     _((WORD *saddr, WORD swb, WORD *daddr, WORD dwb, WORD h));

/*****************************************************************************/

LOCAL  VOID fix_objs (tree)
OBJECT  *tree;

{	WORD    obj;
  OBJECT  *ob;
  ICONBLK *ib;
  BITBLK  *bi;
  UWORD   type;
#if GEM & (GEM2 | GEM3 | XGEM)
  BYTE    *s;
#endif

  if (tree != NULL)
  {
    obj = NIL;

    do
    {
      ob    = &tree [++obj];
      type  = ob->ob_type & 0xFF;

			switch (type)
			{
				case G_ICON:
	        ib = (ICONBLK *)ob->ob_spec.index;
	        ob->ob_height = ib->ib_ytext + ib->ib_htext; /* Hauteur d'objet = Hauteur d'icne */
	        trans_gimage (ib, type);                     /* adapter l'icne  l'cran */
	        break;
	      
	      case G_USERDEF:
		      if (ob->ob_spec.index > 0x600 && ((OBBLK *)ob->ob_spec.index)->old_type == G_CICON)
		      {
		        ib = (ICONBLK *)((OBBLK *)ob->ob_spec.index)->ublk.ub_parm;
		        ob->ob_height = ib->ib_ytext + ib->ib_htext; /* Hauteur d'objet = Hauteur d'icne */
		        trans_gimage (ib, G_CICON);                  /* adapter l'icne couleur  l'cran */
		      }
		      break;
		    
		    case G_IMAGE:
	        bi = (BITBLK *)ob->ob_spec.index;
	        ob->ob_height = bi->bi_hl;        /* Hauteur d'objet = Hauteur d'image */
	        trans_gimage (bi, type);          /* adapter l'image bitmap  l'cran */
	        break;
	    }
    } while (! (ob->ob_flags & LASTOB));
  } /* if */ 
} /* fix_objs */

/*****************************************************************************/

main()
{
	WORD x, y, w, h;

	if (!init_global (0, NULL, NULL, 0))
		return (0);
	else
	{
		graf_mouse (ARROW, NULL);
		form_center (dialbox, &x, &y, &w, &h);
		form_dial (FMD_START, 0, 0, 0, 0, x, y, w, h);
		objc_draw (dialbox, ROOT, MAX_DEPTH, x, y, w, h);
		form_do (dialbox, ROOT);
		form_dial (FMD_FINISH, 0, 0, 0, 0, x, y, w, h);

		term_global ();
	}

	return (0);
}

/*****************************************************************************/
/* Initialisation du module                                                  */
/*****************************************************************************/

LOCAL BOOLEAN init_global (argc, argv, acc_menu, class)
INT  argc;
BYTE *argv [];
BYTE *acc_menu;
WORD class;

{	WORD   i;

  i = appl_init ();                       /* Numro d'application */

#if (LATTICE_C | TURBO_C) | (GEM & (GEM2 | GEM3 | XGEM))
  gl_apid = i;                            /* gl_apid non-externe */
#endif

  if (gl_apid < 0) return (FALSE);

  phys_handle = graf_handle (&gl_wbox, &gl_hbox, &gl_wattr, &gl_hattr); /* Handle de l'cran */
  vdi_handle  = phys_handle;              /* utilise l'cran physique */
  vwork_open  = FALSE;

  wind_get (DESK, WF_WXYWH, &desk.g_x, &desk.g_y, &desk.g_w, &desk.g_h);        /* Taille du bureau */

  open_vwork ();                          /* open virtual Workstation */

#ifdef rgb_palette
	init_xrsrc (vdi_handle, rs_object, NUM_OBS, NUM_CIB, rgb_palette);
#else
	init_xrsrc (vdi_handle, rs_object, NUM_OBS, NUM_CIB, NULL);
#endif
	
  dialbox = rs_trindex[0];                /* adresse de la page d'aide */
  fix_objs (dialbox);
	
  return (TRUE);
} /* init_global */

/*****************************************************************************/
/* fin du module                                                             */
/*****************************************************************************/

LOCAL BOOLEAN term_global ()

{
  if (gl_apid >= 0)
  {
		term_xrsrc (NUM_CIB);		            /* librer le ressource */
    close_vwork ();                     /* fermer la workstation */
    appl_exit ();                       /* terminer l'application */
  } /* if */

  return (TRUE);
} /* term_global */

/*****************************************************************************/
/* open virtual Workstation                                                  */
/*****************************************************************************/

LOCAL VOID open_vwork ()

{
  WORD i;
  WORD work_in [11];
  WORD work_out [57];

  if (! vwork_open)
  {
    vwork_open = TRUE;

    for (i = 0; i < 10; work_in [i++] = 1);
    work_in [10] = RC;                         /* coordonnes graphiques */
    vdi_handle = phys_handle;
    v_opnvwk (work_in, &vdi_handle, work_out); /* open virtual Workstation */
  } /* if */
} /* open_vwork */

/*****************************************************************************/
/* fermeture virtual Workstation                                             */
/*****************************************************************************/

LOCAL VOID close_vwork ()

{
  if (vwork_open)
  {
    v_clsvwk (vdi_handle);                      /* Librer la workstation */
    vdi_handle = phys_handle;                   /* utiliser l'cran physiquen */
    vwork_open = FALSE;
  } /* if */
} /* close_vwork */

/*****************************************************************************/

LOCAL VOID trans_gimage (obspec, typ)
VOID *obspec;
WORD typ;

{
  ICONBLK *piconblk;
  BITBLK  *pbitblk;
  WORD    *taddr;
  WORD    wb, hl;

  switch (typ)
  {
  	case G_CICON  :
		case G_ICON   :
			piconblk = (ICONBLK *)obspec;
			taddr    = piconblk->ib_pmask;
			wb       = piconblk->ib_wicon;
			wb       = wb >> 3;
			hl       = piconblk->ib_hicon;
			
			vdi_trans (taddr, wb, taddr, wb, hl);
			
			taddr = piconblk->ib_pdata;
			break;
			
		case G_IMAGE  :
			pbitblk = (BITBLK *)obspec;
			taddr   = pbitblk->bi_pdata;
			wb      = pbitblk->bi_wb;
			hl      = pbitblk->bi_hl;
			break;
	}

  vdi_trans (taddr, wb, taddr, wb, hl);
} /* trans_gimage */

/*****************************************************************************/

LOCAL VOID vdi_fix (pfd, theaddr, wb, h)
MFDB *pfd;
VOID *theaddr;
WORD wb, h;

{
  pfd->mp  = theaddr;
  pfd->fwp = wb << 3;
  pfd->fh  = h;
  pfd->fww = wb >> 1;
  pfd->np  = 1;
} /* vdi_fix */

/*****************************************************************************/

LOCAL VOID vdi_trans (saddr, swb, daddr, dwb, h)
WORD *saddr;
WORD swb;
WORD *daddr;
WORD dwb;
WORD h;

{
  MFDB src, dst;

  vdi_fix (&src, saddr, swb, h);
  src.ff = TRUE;

  vdi_fix (&dst, daddr, dwb, h);
  dst.ff = FALSE;

  vr_trnfm (vdi_handle, &src, &dst);
} /* vdi_trans */
