|
| setjmp.cpp 
|

	.globl ___mint

#ifdef __MBASE__
#define Mint	__MBASE__@(___mint)
#define Sigmask	__MBASE__@(__sigmask)
#else
#define Mint	___mint
#define Sigmask __sigmask
#endif

	.text
	.even
	.globl _sigsetjmp
_sigsetjmp:
	movel	sp@(4), a0		| address of sigjmp_buf[]
#ifdef __MSHORT__
	movew	sp@(8), a1
#else
	movel	sp@(8), a1
#endif
	movel	a1, a0@(52)		| save sigmask for siglongjmp?
	beq	SETJMP			| no -- call common code
	movel	Sigmask, d0		| save tos emulation signal mask
#ifdef __MSHORT__
	tstw	Mint			| see if MiNT is active
#else
	tstl	Mint
#endif
	beq	nomint			| no -- call common code
	clrl	sp@-			| add no signals to sigmask
	movew	#0x116, sp@-		| Psigblock() system call
	trap	#1			|
	addqw	#6, sp
nomint:
	orw	#1,d0			| make it != 0 (SIGNULL is unmaskable)
	movel	d0, a0@(52)		| save signal mask
	bra	SETJMP			| call common code

	.globl _setjmp
_setjmp:
	movel	sp@(4),a0		| address of jmp_buf[]
	clrl	a0@(52)			| do not restore sigmask on longjmp
SETJMP:
	movel	sp@,a0@			| save return address
	moveml	d2-d7/a2-a7,a0@(4)	| save registers d2-d7/a2-a7
	clrl	d0			| return value is 0
	rts

	.globl _siglongjmp
_siglongjmp:
	.globl _longjmp
_longjmp:
#ifdef __MSHORT__
	tstw	Mint			| see if MiNT is active
#else
	tstl	Mint
#endif
	beq	NOMINT			| no -- do not call sigreturn
	movew	#0x11a, sp@-		| Psigreturn() system call
	trap	#1			| (ignored if not in a sig handler)
	addqw	#2, sp
NOMINT:
	movel	sp@(4),a0		| address of jmp_buf[]
	movel	a0@(52),d0		| want to restore sigmask?
	beq	NORESTORE		| no -- skip restore code
	andw	#-2,d0
	movel	d0, Sigmask		| restore tos emulation signal mask
#ifdef __MSHORT__
	tstw	Mint			| see if MiNT is active
#else
	tstl	Mint
#endif
	beq	NORESTORE		| no -- do not call sigsetmask
	movel	d0, sp@-		| restore signal mask
	movew	#0x117, sp@-		| Psigsetmask() system call
	trap	#1			|
	addqw	#6, sp
NORESTORE:
#ifdef __MSHORT__
	movew	sp@(8),d0		| value to return
#else
	movel	sp@(8),d0		| value to return
#endif
	bne	L1			| may not be 0
	movql	#1, d0
L1:
	moveml	a0@(4),d2-d7/a2-a7	| restore saved reggies
	movl	a0@,sp@			| and the saved return address
	rts
